# Début programme de lecture Télémètre Ultrason (Console)
# Ce programme mesure le télémètre ultrason et affiche la distance dans la console Python.

# S'utiliser avec :
# - Sciencethic 651 049 - Télémètre Ultrason fixe
# - Grove - Ultrasonic Ranger 101020010

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uino Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

# Active le mécanisme de récuperation des différents états des E/S de Plug'Uno ;
plugUno.samplingOn()

################################
# Configuration des E/S
################################
brocheTelemetre = plugUno.get_pin('d:2:u')
# -> d : signifie mode tout-ou-rien/digital
# -> u : numéro de la broche, seul 2/3 sont compatible
# -> u : mode télémètre ultrason

################################
# Utilisation
################################
# lecture de l'interval de temps mesure par le télémètre ultrason
# brocheTelemetre.read()
# -> retourne l'interval de temps en microseconde entre le signal émis et le signal recu.

# Conversion expliqué interval de temps vers distance
def convertirIntervalTempsEnDistance(tempsAlleEtRetour):    
    # distance = vitesseDuSon * temps
    vitesseDuSon = 331 # m/s
    distanceEnMetre = vitesseDuSon * ( tempsAlleEtRetour / 2 ) * 1E-6
    return distanceEnMetre

# Boucle de lecture a la demande
while True :
    if input(
            "\n"
            "Appuyer sur \"ENTRER\" pour effectuer une mesure."
            "\n"
            "Saisir \"stop\" pour mettre fin a l'execution du programme."
            "\n"
    ) == "stop" :
        # Fermer la connexion à Plug'Uno avant de quitter.
        plugUno.exit()
        # Termine l'éxecution du programme Python.
        exit()

    print(
        "Valeur brute : ",
        brocheTelemetre.read(),"us "
        "(soit ",
        "{:.2f}".format( convertirIntervalTempsEnDistance( brocheTelemetre.read() ) * 1E2 ),    
        " cm selon 331 m/s la vitesse du son)"
    )
    
# Fin programme de lecture Télémètre Ultrason (Console) 
